      DECLARE SUB sicher ()
      DECLARE SUB alarm ()
      DECLARE SUB windrichtungen ()
      DECLARE SUB roseweg ()
      DECLARE SUB ton ()
      DECLARE SUB rose ()
      DECLARE SUB aus ()
      DECLARE SUB syncro ()
      DECLARE SUB drucktrend ()
     
      DECLARE SUB stundmark (stunde$)
      DECLARE SUB werte ()
      DECLARE SUB Konfig ()
      DECLARE SUB dverschieb ()
      DECLARE SUB tverschieb ()
      DECLARE SUB neu ()
      DECLARE SUB roll ()
      DECLARE SUB fehler ()
      DECLARE SUB kurve ()
      DECLARE SUB maske (dimt, dimd)
      DECLARE SUB einles (nz!)
      DECLARE SUB Kalles ()
9993  CLEAR : CLS
     
      version$ = "12.01.05"
      DIM SHARED rka1, rka2, errcode, nzsicher
      DIM SHARED wr$(16), dum$, cfg$, com$
      DIM SHARED w(14), kt(256), kd(256), kh(256), kf(256), ws(8), wm(14), ii(14), w1(14), wvgl(14), wb, w2sync(8)
      DIM SHARED einheit$(11), col(8), txt$(8), dim$(8), bil$, ff$, r$, d$, d1$, dd$, k$, g$
      DIM SHARED x0(8), y0(8), yw(1 TO 8, 546), w2(8), wsn(8), bilanz(546), ff(546)
      DIM SHARED nst, xstunde(30), wertstunde(30), locstunde(30), tdruck(183), druck(183)
      DIM SHARED nk, nzahl, dimt, dimd, ti, nfehler, ninput, nzahlmax, ndiff, nmm, dkal, dd, ikd, ikw, ikr, ikg, ik2, dk, nfaux
      DIM SHARED nzk, dueber, tueber, nz, colfehl, colstat, h, dnmax, dtrend, nzsteuer, tol, ninput1, ufak
      DIM SHARED colbil, colwind, colstd
      DIM SHARED mxk, myk, rk, pi, nf50, ffp, wind, tk2, pdampf, tau, ikf, merktol
     
      COLOR 12: PRINT "           Erfassung von Meteodaten fr CONRAD-Telemetriestation     "
                PRINT "          Standard-Werte in Klammern   /   Version Datum:"; version$
      COLOR 15
'     Einlesen Kalibrierdaten
      LOCATE 3, 20: INPUT "Testlauf mit generierten Daten(n):"; g$
      IF g$ <> "j" THEN
        LOCATE 4, 20: INPUT "Dateneingang COMn: n=1,2,3    (1):"; com$
        ELSE
        cfg$ = "t.cfg"
        GOTO 2
      END IF
      IF com$ = "" THEN com$ = "1"
      LOCATE 5, 20: INPUT "Konfigurationsdatei *.cfg   (*=1):"; cfg$
      cfg$ = cfg$ + ".cfg"
      IF cfg$ = ".cfg" THEN cfg$ = "1.cfg"
2     CALL Konfig
      CALL Kalles
      CALL windrichtungen
'     Kontrolldatei Fehler
'     OPEN "fehler.dat" FOR OUTPUT AS #5
      nzsteuer = 1
      nzahlmax = 544: ndiff = nzahlmax - 400
      mxk = 610: myk = 444: rk = 29: pi = 3.14
      n = 6: npos = 2
      colstat = 2
      dkal = .1667
'     einige Farben festlegen
      colbil = 9: colfehl = 8
      colwind = 12
'     Anzahl der zu mittelnden Werte
      CALL ton
      COLOR 8: PRINT "ATLOweich"
      LOCATE n - 1, 20: COLOR 0, 15
      PRINT "  TELMET Konfiguration eingelesen  "
      LOCATE n, 20: COLOR 14, 6
      LOCATE n + 2, npos: COLOR 15, 0
      INPUT "Mittelzeit in Minuten    (4 Minuten)  :", nz
        IF nz = 0 THEN nz = 480:  ELSE nz = nz * 120
        nmerk = nz
      LOCATE n + 3, npos
      INPUT "Bilanz darstellen?           j/n (j)  :", bil$: IF bil$ = "" THEN bil$ = "j"
      LOCATE n + 4, npos
      INPUT "Windgeschwindigkeit messen?  j/n (j)  :", ff$
        IF ff$ = "" THEN ff$ = "j"
          IF ff$ = "j" THEN
           COLOR 14, 1
           LOCATE n + 5, 53: PRINT "0=Conrad-Anemometer U/min "
           LOCATE n + 6, 53: PRINT "1=Conrad-Anemometer m/s   "
           LOCATE n + 7, 53: PRINT "2=Thies-Anemometer  m/s   "
           LOCATE n + 4, 53
           COLOR 14 + 16, 1: INPUT "Anemometer 0,1,2 (0)    :", ffp
           COLOR 14, 1: LOCATE n + 4, 53
             IF ffp = 1 THEN PRINT "  C   O   N   R   A   D   "
             IF ffp = 2 THEN PRINT "   T    H    I    E   S   "
             IF ffp = 0 THEN PRINT "  C O N R A D   in U/min  "
          END IF
      LOCATE n + 5, npos: COLOR 15, 0
      INPUT "Windrichtung        messen?  j/n (j)  :", dd$: IF dd$ = "" THEN dd$ = "j"

      LOCATE n + 6, npos
      INPUT "Hhe ber NN zur Druckreduktion (460m):", h
      IF h = 0 THEN h = 460
'     Datei zur Datenspeicherung
      COLOR 14: LOCATE n + 7, npos
      INPUT "Datei Speicherung (JJMMTTSS.dat)n=nein:", d$
      t$ = TIME$: v$ = DATE$
      IF d$ = "" THEN d$ = RIGHT$(v$, 2) + LEFT$(v$, 2) + MID$(v$, 4, 2) + LEFT$(t$, 2) + ".dat"
      LOCATE n + 9, npos: COLOR 14
      
      PRINT "Ramdrive-Zwischenspeicherung j/n    "
      LOCATE n + 10, npos
      INPUT "bei N Sicherheitsspeicherung     (j)  :", r$
      IF r$ = "" THEN r$ = "j"
     
     
      IF r$ <> "j" THEN d1$ = d$:  ELSE : d1$ = "d:\temp"
      LOCATE n + 11, npos: COLOR 15
'     Fehlertoleranz bei Telemetrie 20, bei Kabel 100 (Bereich:0-256)
      INPUT "Telemetrie (t) oder Kabel (k)    (t)  :", k$
      IF k$ = "k" THEN tol = 100:  ELSE tol = 20
      merktol = tol
'     Eingangssynchronisation der Schnittstelle
      IF g$ <> "j" THEN CALL syncro

'     Zur Dimensionierung wird ein Grobwert eingelesen
      nz = 1
      CALL einles(nz)
'     dnmax=30 fr 30 min Drucktrend 180 fr 3h
      nz = nmerk: dnmax = 180

'     Dimensionierung Temperatur und Druck
      dimt = INT(wm(ikr)) + 2
'      um die Temperatur 0C als Linie und Wert nachher in der Grafik zu zeigen,
'      wird die Zentraltemperatur dimt ein durch 4 teilbarer Wert zugeordnet
      FOR ndimt = -28 TO 36 STEP 4
'      ist der Wert schon durch 4 teilbar, Schleife verlassen
        IF dimt = ndimt THEN GOTO 80
'      ist die Zentraltemp. grsser als der nchste durch 4 teilbare Wert,
'      wird der nchste kleinere verwendet
        IF dimt > ndimt AND dimt < ndimt + 4 THEN
          dimt = ndimt
          GOTO 80
        END IF
80     NEXT ndimt
     
      dimd = INT(wm(ikd))
'     LOCATE 18, 18
'     PRINT "Temperatur="; dimt; " C        Druck="; dimd
'     LOCATE 19, 36: INPUT "ENTER=weiter, s+ENTER=Stop"; dum$
'     IF dum$ = "s" THEN END
'     Grafikmaske
      CALL maske(dimt, dimd)

'     Einlesen, Zuordnen und Mitteln der Daten
1     CALL einles(nz)
'        Neustart
         IF dum$ = "n" THEN CLOSE #1: SCREEN 0: CALL ton: INPUT "NEUSTART ENTER", dum$: GOTO 9993
'     Zhler ber alles
      nzk = nzk + 1
      
      nzahl = nzahl + 1
'     Stundenmarken erkennen und zeichnen
      t$ = TIME$
      stunde$ = LEFT$(t$, 2)
      IF nzk > 1 AND stunde$ <> stalt$ THEN CALL stundmark(stunde$)
      stalt$ = stunde$


'     Kurven fortfhren und numerische Werte, Drucktrend
      CALL kurve
      CALL werte
      IF nz >= 120 THEN CALL drucktrend

'      Rollen wenn nzahl=nzahlmax
      IF nzahl = nzahlmax THEN CALL roll
'     Fehlerzhler rcksetzen
      nfehler = 0
      ninput1 = 0
     
     
     
      GOTO 1

'     COM- Port schlieen und beenden
9     CLOSE #1
      END
fehlers:
'       Fehlerrcksprung aus UP EINLES (On Error Goto ...)
123     nfaux = 1
        CALL fehler
        RESUME

      SUB alarm
'     Fehlermeldungen, Ausgabe in Statuszeile, Alarmton
     
      LOCATE 1, 9: COLOR 13
      
      IF errcode = 1 THEN PRINT "Fehlertoleranz >= 200, bel. Taste weiter";
5555  FOR ns = 1 TO 50
        SOUND 1000 + ns * 100, .1
        SOUND 30000 - ns * 100, .1
        IF INKEY$ <> "" THEN GOTO 5551
      NEXT ns
      GOTO 5555
5551  END SUB

      SUB aus
'     Ende mit Zwischenpuffer von Ramdrive auf Platte schreiben
      IF r$ <> "j" THEN END
      IF d1$ = "n" THEN END
      CLS
      LOCATE 20, 10
      PRINT "Umspeicherung Ramdisk auf Platte"
      CLOSE #3
      OPEN d1$ FOR INPUT AS #3
      OPEN d$ FOR OUTPUT AS #4
22222 IF EOF(3) THEN GOTO 22221
      LINE INPUT #3, dum$
      PRINT #4, dum$
      GOTO 22222
22221 CLOSE (4)
      END
     
     
      END SUB

      SUB drucktrend
'     Kellerspeicherung von Zeit in Sekunden und Druck
'     Werte rutschen von dnmax bis 1
      tdruck(dnmax) = TIMER
      druck(dnmax) = wm(ikd)
      FOR nkn = 1 TO dnmax - 1
        tdruck(nkn) = tdruck(nkn + 1)
        druck(nkn) = druck(nkn + 1)
      NEXT nkn
'     Vergleichsschleife, es wird bei grsster Zeitdistanz begonnen
'     und Schleife verlassen wenn tdiff=3h gefunden
      FOR nkn = 1 TO dnmax
        tdiff = TIMER - tdruck(nkn)
'       Abfangen des Zeitsprunges bei 0 Uhr
        IF tdiff < 0 THEN tdiff = tdiff + 86400

'       Sobald erstmalig tdiff gleich oder kleiner 3h wird dtrend berechnet
'       aber erst, wenn Werte im Keller bei nkn angekommen sind
'       tdiff=10800 fr 3h, 1800 fr 0.5 h, ein 4-Minutenfenster wird erlaubt
        IF tdiff <= 10920 AND tdiff >= 10680 AND tdruck(nkn) <> 0 THEN
          dtrend = druck(dnmax) - druck(nkn)
          GOTO 112
        END IF
      NEXT nkn
112
      END SUB

      SUB dverschieb
'     Druckwerte verschieben, alle Kanle bearbeiten
      FOR m = 1 TO nk
        IF einheit$(m) = "d" THEN
          FOR mm = 1 TO nzahl
            yw(m, mm) = yw(m, mm) + (2 * 40) * dueber
          NEXT mm
          y0(m) = y0(m) + (2 * 40) * dueber
        END IF
      NEXT m
      CALL neu
     
      END SUB

      SUB einles (nz)
'     Schleife ber zu mittelnde Werte
      nmm = 0
'     Zeit merken fr Windzhler
      ti1 = TIMER
'     um die Schleifenvariable in der Schleife ndern zu knnen, wird nmm nicht als FOR verwendet

9991  nmm = nmm + 1
9992   ninput = ninput + 1
       ninput1 = ninput1 + 1

'      Datenschleife ber 14 Bytes
       FOR i = 1 TO 14

        dum$ = INKEY$
        IF dum$ = "s" THEN CALL ton: CALL aus
'      manuelle Umspeicherung von Ramdrive auf Platte
        IF dum$ = "z" AND r$ = "j" AND d1$ <> "n" THEN CALL ton: CALL sicher
'      inkey fr Toleranznderung
       IF dum$ = "+" THEN CALL ton: tol = tol + 20
       IF dum$ = "-" THEN CALL ton: tol = tol - 20: IF tol < 10 THEN tol = 10
            IF dum$ = "+" OR dum$ = "-" THEN merktol = tol
'      inkey fr Ab- und Anschaltungen
       IF dum$ = "d" THEN CALL ton: dd$ = "j"
       IF dum$ = "0" THEN CALL ton: dd$ = ""
       IF dum$ = "f" THEN CALL ton: ff$ = "j"
       IF dum$ = "z" THEN CALL ton: ff$ = ""
       IF dum$ = "b" THEN CALL ton: bil$ = "j"
       IF dum$ = "i" THEN CALL ton: bil$ = ""
       IF dum$ = "g" THEN CALL ton: CALL tverschieb
      
       IF dum$ = "n" THEN GOTO 987
'      inkey fr nderung der Mittelzeit
       IF dum$ = "2" OR dum$ = "4" THEN
         CALL ton
         IF dum$ = "2" THEN nz = nz / 2
         IF dum$ = "4" THEN nz = nz * 2
         LOCATE 57, 61: COLOR 15: PRINT USING "#.##"; (nz / 120)
       END IF
       dum$ = ""

'       Ein Datenbyte vom Telemetrie- Modul einlesen

'        Bei E/A-Fehler wird das UP EINLES vorbergehend verlassen
         IF g$ = "j" THEN GOTO 23
         ON ERROR GOTO fehlers: IN$ = INPUT$(1, #1): ON ERROR GOTO 0

'       Daten als ASCII umspeichern
23      IF g$ <> "j" THEN
         
         w(i) = ASC(IN$)
         ELSE
'            Testdatengenerierung
          IF i = 1 THEN w(i) = INT(56 + RND * 12) 'eine Temperatur um 10 C
          IF i = 2 THEN w(i) = INT(75 + RND * 20) 'eine Feuchte um 80 %
          IF i = 3 THEN w(i) = INT(60 + RND * 12) 'eine Temperatur um 12 C
          IF i = 4 THEN w(i) = INT(178 + RND * 6) 'ein Druck um 1000 hPa
          IF i = 5 THEN w(i) = INT(84 + RND * 20) 'Helle in %
          IF i = 6 THEN w(i) = 0                  'nicht belegt
          IF i = 7 THEN w(i) = 100                'Konstante 100
          IF i = 8 THEN w(i) = INT(100 + RND * 12) 'eine Windrichtung
         END IF

'       w(i) = 70 + nzk / 60

       NEXT i
'      nach Einleseschleife erfolgt Fehlererkennung
       FOR i = 1 TO 11
'      Fehlererkennung: Umspeicherung und Tolerierung einer Abweichung
'      nur fr belegte Kanle und zustzlich fr Zhler Kanal 11
'      nicht fr Windrichtung , zu starke Schwankungen
            IF einheit$(i) = "w" THEN GOTO 22
         IF ninput > 1 AND ABS(wvgl(i) - w(i)) > tol THEN
         
'         PRINT #5, TIME$;
'         PRINT #5, USING "####.#"; i; wvgl(i); w(i)

'          Bei Fehler wird die Bearbeitungs-i-Schleife verlassen
'          Zhler fr log. Fehler zur Toleranzerhhung
           nftol = nftol + 1
'          ab 50 Fehler laufend wird Toleranz in Schritten erhht
             IF nftol > 49 THEN
               tol = tol + 10
               LOCATE 1, 8: COLOR 12: PRINT "    automatische Erhhung der Fehlertoleranz         "
               COLOR 13: LOCATE 1, 76: PRINT USING "###"; tol
               IF tol = 200 THEN errcode = 1: CALL alarm
             END IF
           f$ = "f"
           GOTO 91
         END IF
22
       NEXT i
       nftol = 0
'      Rckstellung der Fehlertoleranz
       tol = merktol

'      jetzt Umspeicherung zum Vergleich und Zuordnung
       FOR i = 1 TO 11
         wvgl(i) = w(i)
         
'       aus Rundungsgrnden sofort Zuordnung zum Kalibrierwert, nur Analogkanle
        IF i <= 8 THEN

'         Temperatur
          IF ii(i) = i AND einheit$(i) = "t" THEN
            w1(i) = kt(w(i))

'             nochmals Vergleich mit Vorwert zur Fehlererkennung abgeschaltet
'             IF nzahl > 1 AND ABS(w1(i) - w2(i)) > 5 THEN w1(i) = w2(i)
'           w2(i) = w1(i)
'             Merken der Temperatur fr sptere Feuchteberechnungen
              IF ikr = i THEN T1f = w1(i)
            GOTO 5
          END IF

'         Druck
          IF ii(i) = i AND einheit$(i) = "d" THEN
            w1(i) = kd(w(i))
'             nochmals Vergleich mit Vorwert zur Fehlererkennung abgeschaltet
'             IF nzahl > 1 AND ABS(w1(i) - w2(i)) > 2 THEN : w1(i) = w2(i)
'           w2(i) = w1(i)
            GOTO 5
          END IF

'         Feuchte
          IF ii(i) = i AND einheit$(i) = "f" THEN
            ikf = i
            w1(i) = kf(w(i))
'           w2(i) = w1(i)
'           Berechnung Dampfdruck (hPa) und Taupunkt
            pdampf = 6.1 * 10 ^ ((7.45 * T1f) / (235 + T1f)) * w1(i) / 100
            IF pdampf > .1 THEN
             tau = (235 * LOG(pdampf / 6.104) * .43429) / (7.45 - LOG(pdampf / 6.104) * .43429)
             ELSE
             tau = -99.9
            END IF
            GOTO 5
          END IF

'         Windrichtung
          IF ii(i) = i AND einheit$(i) = "w" AND dd$ = "j" THEN
            w1(i) = w(i) * 1.43
            dd = w1(i)
'           w2(i) = w1(i)
'         zur Mittelung Umrechnung in u-v-Komponenten, Bogenma
            u = SIN(w1(i) * pi / 180)
            v = COS(w1(i) * pi / 180)

            GOTO 5
          END IF


'         Spannung, Kennung="u" linear
          IF einheit$(i) = "u" THEN
            w1(i) = w(i) * ufak
'         Alarm bei Spannung <11 Volt
              IF w1(i) <= 11 THEN
                FOR m = 40 TO 1 STEP -1: SOUND m * 10 + 100, .1: NEXT m
                utext$ = "Spannung unter 11 Volt                      "
              END IF
          END IF

'         Helligkeit mit Kalibrierdatei lux.tab Kennung h
'         .... zur Anpassung Helle*2.5 fr Solarzellenfhler
          IF einheit$(i) = "h" THEN
            w1(i) = kh(w(i)) * 2.5
          END IF
'         Helligkeit mit Eigenbaufhler, Umrechnung linear Kennung *
          IF einheit$(i) = "*" THEN
            w1(i) = ((255 - w(i)) / 2.5) * 1.3966
          END IF
'        Addition der Einzelwerte
5        ws(i) = w1(i) + ws(i)
'        Windrichtung extra
         IF einheit$(i) = "w" AND dd$ = "j" THEN
           usum = usum + u
           vsum = vsum + v
         END IF
'        Zhler wie oft wird summiert bei vorzeitigem Schleifenausstieg
         wsn(i) = wsn(i) + 1
        END IF

'       Zhlereingang Windgeschwindigkeit, fest auf Kanal 11
        IF i = 11 AND ff$ = "j" THEN
          w1(i) = w1(i) + w(i)
        END IF
       
        NEXT i
91      IF INKEY$ = "f" OR f$ = "f" THEN
           CALL fehler
           f$ = ""
           GOTO 9992
        END IF
'       alle Werte als Statuszeile in der Grafik ausgeben, Windrose
      
        IF dd$ = "j" AND ninput > 1 THEN : CALL rose
        IF dd$ <> "j" AND ninput > 1 THEN : CALL roseweg
       
        IF colstat > 15 THEN colstat = 1:  ELSE colstat = 15
        COLOR colstat
        colstat = colstat + 14
        
        FOR m = 0 TO nk - 1
          LOCATE 1, m * 6 + 8
          PRINT USING "####.#"; w1(m + 1);
        NEXT m
        PRINT "   "; w(11);
        COLOR 13: LOCATE 1, 76: PRINT USING "###"; tol
'       Entfernung Fehlerzeichen durch berschreiben mit Leerzeichen
        LOCATE 1, 75:  PRINT " "

'       berschreiben der Statuszeile mit Spannungswarnung
        LOCATE 1, 10: PRINT utext$
        utext$ = ""
'       Fortschrittsanzeiger
        
        IF ninput > 1 AND nz > 1 THEN
          LINE (0, 400 - 4)-(0, 400 - 4 - nmm * (400 - 4) / (nz - 1)), 15
          LINE (1, 400 - 4)-(1, 400 - 4 - nmm * (400 - 4) / (nz - 1)), 15
        END IF
'     Ende der Mittelwertschleife
      IF nmm < nz THEN GOTO 9991
'     Zeit am Ende der Schleife
      ti2 = TIMER

'     Mittelbildung, Summe auf Null setzen
      
      FOR n = 1 TO 8
       IF wsn(n) <> 0 THEN wm(n) = ws(n) / wsn(n)

'      Korrektur des Temperaturwertes vom 2. Kanal (Strahlung)
'      notwendig, da dieselbe Tabelle verwendet wird
         IF n = ik2 THEN wm(n) = wm(n) + tk2

'      Korrektur des Druckwertes in Abh. der Temperatur, dafr wird Kanal
'        ikg verwendet und zus. Druckkorrektur mit aus cfg Wert dk
         IF einheit$(n) = "d" THEN wm(n) = wm(n) + dkal * wm(ikg) + dk
'      Windrichtung Rckrechnung u-v-Komponenten in Grad
         IF einheit$(n) = "w" AND dd$ = "j" THEN
           usum = usum / wsn(n): vsum = vsum / wsn(n)
'          Quadrantenabfrage fr Gradrckrechnung
           winkel = ATN(ABS(usum) / ABS(vsum)) * 180 / pi
           IF usum > 0 AND vsum > 0 THEN wm(n) = winkel
           IF usum > 0 AND vsum < 0 THEN wm(n) = 180 - winkel
           IF usum < 0 AND vsum > 0 THEN wm(n) = 360 - winkel
           IF usum < 0 AND vsum < 0 THEN wm(n) = 180 + winkel
           usum = 0: vsum = 0
         END IF
'     Windrichtung abgeschaltet
         IF einheit$(n) = "w" AND dd$ <> "j" THEN wm(n) = -99.9

       ws(n) = 0
       wsn(n) = 0
      NEXT n
'     falls gesetzt, wird die Bilanz als Differenz Temp 2-Temp 1 berechnet
      IF bil$ = "j" THEN wb = wm(ik2) - wm(ikr)
'     Windgeschwindigkeit als Zhlereingangssumme pro Zeitdifferenz
'       Abfangen des Zeitsprunges von 24 Uhr auf 0 Uhr
        IF ff$ = "j" THEN
          tdiff = ti2 - ti1
          IF tdiff < 0 THEN tdiff = tdiff + 86400
          IF tdiff = 0 THEN tdiff = .5
          wm(11) = w1(11) / (tdiff / 60)
'     ggf. Umrechnung u/min in m/s, bei ffp=0 wird u/min beibehalten
          IF ffp = 0 THEN wind = wm(11)
          IF ffp = 1 THEN wind = wm(11) / 60 * 1.26
          IF ffp = 2 THEN wind = wm(11) / 60 * .8

        ELSE
          wm(11) = 0
        END IF
     
      w1(11) = 0
'     Fortschrittsanzeiger = schwarz
      IF ninput > 1 THEN
        LINE (0, 400 - 4)-(0, 0), 0
        LINE (1, 400 - 4)-(1, 0), 0
      END IF
'      obligatorische Umspeicherung von Ramdrive auf Platte nach 360 Werten,
'      entspricht bei 4-Minutenmittel 1 Tag
      nzsicher = nzsicher + 1
      IF nzsicher = 360 AND r$ = "j" AND d1$ <> "n" THEN nzsicher = 0: CALL sicher
   
987   END SUB

    SUB fehler
    CLOSE #1
    ti = TIMER
'   Port wird geschlossen und wieder geffnet
'   COM- Port ffnen: 2400 Baud, kein Parittsbit, 8 Datenbits, 1 Stopbit
    IF com$ = "1" THEN OPEN "COM1:2400,N,8,1,RS,CS,DS,CD" FOR INPUT AS #1
    IF com$ = "2" THEN OPEN "COM2:2400,N,8,1,RS,CS,DS,CD" FOR INPUT AS #1
    IF com$ = "3" THEN OPEN "COM3:2400,N,8,1,RS,CS,DS,CD" FOR INPUT AS #1
'   Fehlerzeichen, Blinkanzeige
' bei nur Portfehler keine Ausfallbehandlung
    IF nfaux = 1 THEN GOTO 9944
    colfehl = colfehl + 2
    IF ninput > 1 THEN LOCATE 1, 75: COLOR colfehl: PRINT "F"
    IF colfehl = 12 THEN colfehl = 8

'   Die Werte vom vorigen Input werden verwendet
    FOR ii = 1 TO 11
      w(ii) = wvgl(ii)
    NEXT ii

'   und der Mittelwertszhler wird um 1 hochgesetzt
    nmm = nmm + 1
    nfehler = nfehler + 1
9944  nfaux = 0
    END SUB

      SUB Kalles
'     ffnen und einlesen Kalibrierdateien
      OPEN "kty.tab" FOR INPUT AS #1
      OPEN "baro.tab" FOR INPUT AS #2
      OPEN "hyg.tab" FOR INPUT AS #3
      OPEN "lux.tab" FOR INPUT AS #4
      FOR n = 1 TO 256
        INPUT #1, kt(n)
        INPUT #2, kd(n)
        INPUT #3, kf(n)
        INPUT #4, kh(n)
      NEXT n
      CLOSE #1, #2, #3, #4
      END SUB

      SUB Konfig
      OPEN cfg$ FOR INPUT AS #5
      INPUT #5, nk
      FOR n = 1 TO nk
        INPUT #5, dum$
        ii(n) = VAL(LEFT$(dum$, 1))
        einheit$(n) = MID$(dum$, 2, 1)
        txt$(n) = MID$(dum$, 3, 6)
        dim$(n) = MID$(dum$, 9, 6)
        col(n) = VAL(RIGHT$(dum$, 2))
'  Feststellen, welcher Kanal ist Druck und Windrichtung
        IF (einheit$(n) = "d") THEN ikd = n
        IF (einheit$(n) = "w") THEN ikw = n
      NEXT n
'  Einlesen von: Temperaturkanal, mit dem Druckreduktion erfolgt (Luft)
'                Kanal der Gertetemperatur
'                Kanal mit Strahlungstemperatur
'                Temperaturkorrektur Temperatur 2 (da dieselbe Kalibrierdatei)
'                Spannungskorrekturfaktor fr Spannungsmessung
'                Druckkorrektur
      INPUT #5, ikr, ikg, ik2, tk2, ufak, dk

      CLOSE #5

      END SUB

      SUB kurve
      x = nzahl + 49
     
'     Bilanz zeichnen, Nullinie mit PSET und umspeichern fr Rollen
      IF bil$ = "j" THEN
        ywb = 80 - wb * 20 - 4
          IF ywb < 0 THEN ywb = 0
        LINE (x, 80 - 4)-(x, ywb), colbil
        PSET (x, 80 - 4), 15
        bilanz(nzahl) = ywb
      ELSE
        bilanz(nzahl) = 80 - 4
      END IF
     
'     Windgeschwindigkeit zeichnen als Balkengrafik von unten
'     20 Pixel Balkenlnge bei 1m/s
      IF ff$ = "j" THEN
        ywf = 400 - 4 - wind * 20
        LINE (x, 400 - 4)-(x, ywf), colwind
        ff(nzahl) = ywf
      ELSE
        ff(nzahl) = 400 - 4
      END IF


'     Kurven
      FOR n = 1 TO nk
'       nichtbelegte Kanle mit Kennung "0" werden bersprungen
'       genauso Kanle mit Farbe grau=8
        IF einheit$(n) = "0" OR col(n) = 8 THEN GOTO 991
'       Windrichtung beginnt bei 280-4 und endet bei 360/2=180 Pixel hher
'        wird gleich gezeichnet, da keine Kurve
'           damit bei Abschaltung der Windrichtung keine Kurve gezeichnet wird
'           gleich Sprung zum Schleifenende bei dd$<>j
        IF einheit$(n) = "w" AND dd$ <> "j" THEN yw(n, nzahl) = -99.9: GOTO 221
        IF einheit$(n) = "w" THEN
          y = 280 - 4 - wm(n) * .4
          LINE (x, y - 3)-(x, y + 3), col(n)
          yw(n, nzahl) = y
          GOTO 221
        END IF
        IF einheit$(n) = "t" THEN y = 240 - (wm(n) - dimt) * 10 - 4
        IF einheit$(n) = "d" THEN y = 160 - (wm(n) - dimd) * 10 - 4

'       Feuchte wird wie Helligkeit auf 100 normiert, Skala beginnt bei Wert 0
'         mit Pixel 400-4 und endet bei 100 mit 200-4 gleich 400-4+200
        IF einheit$(n) = "f" THEN y = 400 - 4 - wm(n) / 100 * 200

'       Helligkeit, min bei 400-4, Maximum bei 200-4
        IF einheit$(n) = "h" OR einheit$(n) = "*" THEN y = 400 - 4 - wm(n) / 100 * 200

'       Spannungen werden nicht gezeichnet
        IF einheit$(n) = "u" THEN GOTO 991

'       In Arbeitsspeicher fr spteres Rollen
        yw(n, nzahl) = y
       
'     Sonderbehandlung erster Wert
        IF nzahl = 1 THEN
          PSET (x, y), col(n)

'     Kurvenfortfhrung
        ELSE
          LINE (x0(n), y0(n))-(x, y), col(n)
       
       
        END IF

'     Umspeicherung
221     x0(n) = x: y0(n) = y
        IF nzahl = nzahlmax THEN x0(n) = x0(n) - ndiff
     
991
      NEXT n


'     berprfung auf Bereichsberschreitung
      FOR n = 1 TO nk
'       Temperaturen, Verschiebung erst spter da mehrere Kurven, 40 Grad als obere Grenze
        IF einheit$(n) = "t" THEN
          IF wm(n) >= dimt + 23 AND wm(n) < 40 THEN tueber = 1: dimt = dimt + 8
          IF wm(n) <= dimt - 16 THEN tueber = -1: dimt = dimt - 8
        
        END IF
        IF einheit$(n) = "d" THEN
'       Druck
          IF wm(n) >= dimd + 15 THEN dueber = 1: dimd = dimd + 8
          IF wm(n) <= dimd - 24 THEN dueber = -1: dimd = dimd - 8
        END IF
      NEXT n

      IF tueber <> 0 THEN CALL tverschieb
      IF dueber <> 0 THEN CALL dverschieb
      tueber = 0: dueber = 0
     
     
      END SUB

      SUB maske (dimt, dimd)
      SCREEN 12: WIDTH 80, 60: CLS
'      Festlegung der Beschriftungswerte
'      Temperatur Gesamtbereich 40 Grad, Druck 20 hPa
'      Zuordnung der nchsten Integerzahl als Startwertes aus tdim
      dumt = dimt
      dumd = INT(dimd + .5)

'     Beschriftung Achsen
'      Striche, es werden bei y 4 Pixel zur Zentrierung der Zahlen abgezogen
      COLOR 15
      FOR j = 1 TO 10
       LINE (49, j * 40 - 4)-(591, j * 40 - 4), 8

'       Temperatur Start in Pixel y= 240
       LOCATE j * 5, 2
       PRINT dumt + 24 - j * 4

'       Druck Start in Pixel y=160
       LOCATE j * 5, 75
       PRINT dumd + 16 - 4 * j
      NEXT j
     
      COLOR 15
      LINE (48, 0)-(592, 400 - 4), 7, B
      
'     Tabelle horizont. Linien
      FOR n = 0 TO 3
        IF n = 1 THEN cl = 15 ELSE cl = 7
        LINE (1, 412 + n * 16)-(579, 412 + n * 16), cl
      NEXT n
        LINE (1, 412 + n * 16 + 3)-(579, 412 + n * 16 + 3), cl

'     Tabelle vertikale Linien
      FOR n = 0 TO 7
        LINE (51 + n * 56, 412)-(51 + n * 56, 480), 7
        LINE (51 + n * 56 + 1, 412)-(51 + n * 56 + 1, 480), 7
      NEXT n
      LINE (445, 412)-(445, 480), 7
      LINE (517, 412)-(517, 480), 7
      LINE (579, 412)-(579, 480), 7

'     Fuss-und Kopflinie Fortschrittszeiger
      LINE (0, 400 - 4)-(4, 400 - 4), 15
      LINE (0, 400 - 3)-(4, 400 - 3), 15
      LINE (0, 0)-(4, 0), 15
      LINE (0, 1)-(4, 1), 15
     
'     Legenden einfgen
      FOR n = 0 TO 7
        COLOR 15
        LOCATE 53, n * 7 + 1
        PRINT txt$(n + 1)
        COLOR 7
        LOCATE 55, n * 7 + 1
        PRINT dim$(n + 1)
      NEXT n
      LOCATE 55, 57: COLOR 15: PRINT "Z:"
      LOCATE 53, 66: COLOR 15: PRINT "F"
      LOCATE 55, 66: COLOR 15: PRINT "%"
      LOCATE 57, 66: COLOR 15: PRINT ">50%"
      LOCATE 57, 57: COLOR 15: PRINT "Min:"
      LOCATE 59, 57: COLOR 15: IF ffp = 0 THEN PRINT "F U/min:"; :  ELSE PRINT "F   m/s";
'     100er- Marke fr Feuchte und Helle
      COLOR 14
      LOCATE 26, 77: PRINT "100%";
      LOCATE 31, 77: PRINT "80%";
      LOCATE 36, 77: PRINT "60%";
      LOCATE 41, 77: PRINT "40%";
      LOCATE 46, 77: PRINT "20%";
'     Skala fr Windrichtung
      COLOR 6
     
      LOCATE 19, 77: PRINT "300"
      LOCATE 24, 77: PRINT "200";
      LOCATE 29, 77: PRINT "100";
      LOCATE 34, 77: PRINT "0";
'     Skala fuer Windgeschwindigkeit
      COLOR colwind
      LOCATE 47, 77: PRINT "2m/s";
      LOCATE 42, 77: PRINT "4m/s";
      LOCATE 37, 77: PRINT "6m/s";
      LOCATE 32, 77: PRINT "8m/s";
      LOCATE 27, 76: PRINT "10m/s";
      END SUB

      SUB neu
'     Neuzeichnen nach Bereichsnderung
     
     
      CALL maske(dimt, dimd)
     
'     Neuzeichnen der Stundenmarken
      FOR n = 1 TO nst
        LINE (xstunde(n), 400 - 4)-(xstunde(n), 1), 7
        IF colstd = 15 THEN colstd = 7:  ELSE colstd = 15
        LOCATE 51, locstunde(n)
        COLOR colstd: PRINT USING "##"; wertstunde(n)
      NEXT n

'     Bilanz
      IF bil$ = "j" THEN
        FOR n = 1 TO nzahl
          LINE (n + 49, 80 - 4)-(n + 49, bilanz(n)), colbil
          PSET (n + 49, 80 - 4), 15
        NEXT n
      END IF

'     Windgeschwindigkeit
      IF ff$ = "j" THEN
        FOR n = 1 TO nzahl
          LINE (n + 49, 400 - 4)-(n + 49, ff(n)), colwind
        NEXT n
      END IF

'     Kurven rckwrts damit Windrichtung berzeichnet wird
      FOR n = nk TO 1 STEP -1
        IF einheit$(n) = "u" OR einheit$(n) = "0" THEN GOTO 93
        FOR nn = 1 TO nzahl - 1
'     Windrichtung zuerst
          IF einheit$(n) = "w" AND dd$ <> "j" THEN GOTO 94
          IF einheit$(n) = "w" THEN
          IF yw(n, nn + 1) <> -99.9 THEN LINE (nn + 50, yw(n, nn + 1) - 3)-(nn + 50, yw(n, nn + 1) + 3), col(n)
          GOTO 94
          END IF
          LINE (nn + 49, yw(n, nn))-(nn + 50, yw(n, nn + 1)), col(n)
94
        NEXT nn
93
      NEXT n

      CALL werte
      END SUB

      SUB roll
'     gerollt wird bis 400
'     Umspeicherung
      FOR n = 1 TO nk
        FOR nn = 1 TO 400
          yw(n, nn) = yw(n, nn + ndiff)
        NEXT nn
      NEXT n
'     Bilanz umspeichern und Windgeschwindigkeit
      FOR n = 1 TO 400
        bilanz(n) = bilanz(n + ndiff)
        ff(n) = ff(n + ndiff)
      NEXT n

'     Stundenmarken versetzen
'       Zahl derselben ist nst
      FOR n = 1 TO nst

'     es wird nur umgespeichert, wenn die Marken nicht links raus fallen
'     vorher 1 bis nst, nachher 1 bis nneu
        IF (xstunde(n) - ndiff) > 49 THEN
          nneu = nneu + 1
          xstunde(nneu) = xstunde(n) - ndiff
          locstunde(nneu) = locstunde(n) - INT(ndiff / 8 + .5)
          wertstunde(nneu) = wertstunde(n)
        END IF
      NEXT n
'     nneu wird das neue nst
      nst = nneu
      nneu = 0
      CALL maske(dimt, dimd)

'     zuerst werden die verschobenen Stundenmarken gezeichnet
      FOR n = 1 TO nst
        LINE (xstunde(n), 400 - 4)-(xstunde(n), 1), 7
        IF colstd = 15 THEN colstd = 7:  ELSE colstd = 15
        LOCATE 51, locstunde(n)
        COLOR colstd: PRINT USING "##"; wertstunde(n)
      NEXT n

'     dann zeichnen der Bilanz
      IF bil$ = "j" THEN
        FOR n = 1 TO 400
          LINE (n + 49, 80 - 4)-(n + 49, bilanz(n)), colbil
          PSET (n + 49, 80 - 4), 15
        NEXT n
      END IF
'     dann Windgeschwindigkeit
      IF ff$ = "j" THEN
        FOR n = 1 TO 400
          LINE (n + 49, 400 - 4)-(n + 49, ff(n)), colwind
        NEXT n
      END IF

'      Start neue Kurve festlegen
      nzahl = 400

'     Neuzeichnen bis 400 rckwrts damit Windrichtung berzeichnet wird
      FOR n = nk TO 1 STEP -1
        IF einheit$(n) = "u" OR einheit$(n) = "0" OR col(n) = 8 THEN GOTO 92
       
        FOR nn = 1 TO 399
'         Windrichtung zuerst
          IF einheit$(n) = "w" AND dd$ <> "j" THEN GOTO 95
          IF einheit$(n) = "w" THEN
            IF yw(n, nn + 1) <> -99.9 THEN LINE (nn + 50, yw(n, nn + 1) - 3)-(nn + 50, yw(n, nn + 1) + 3), col(n)
            GOTO 95
          END IF
         
          LINE (nn + 49, yw(n, nn))-(nn + 50, yw(n, nn + 1)), col(n)
95
        NEXT nn
92
      NEXT n
      CALL werte
      END SUB

      SUB rose
REM  alten Pfeil bermalen mit Farbe
      LINE (mxk, myk)-((mxk + rka1), (myk - rka2)), 2
      CIRCLE (mxk, myk), rk, 15:
      rk1 = rk * SIN(dd * pi / 180): rk2 = rk * COS(dd * pi / 180)
REM  neuen Pfeil setzen
      LINE (mxk, myk)-((mxk + rk1), (myk - rk2)), 12
      rka1 = rk1: rka2 = rk2
     
     
     
      END SUB

      SUB roseweg
REM   alten Pfeil lschen
'      LINE (mxk, myk)-((mxk + rka1), (myk - rka2)), 0
'      CIRCLE (mxk, myk), rk, 0
'      PAINT (mxk, myk), 0
     
      LINE (581, 413)-(640, 480), 0, BF
     
      END SUB

      SUB sicher
REM      CALL ton
'     Sicherungsspeicherung Ramdrive auf Platte bei Betrieb
'      dabei wird eine existierende Kopie von der aktuellen, die den Teil
'      der existierenden mit enthlt, berschrieben.
33330 CLOSE #3
      OPEN d1$ FOR INPUT AS #3
      OPEN d$ FOR OUTPUT AS #4
33333 IF EOF(3) THEN GOTO 33331
      LINE INPUT #3, dum$
      PRINT #4, dum$
      GOTO 33333
33331 CLOSE (4): CLOSE (3)

      END SUB

      SUB stundmark (stunde$)
'     Stundenmarken zeichnen, x-Position xstunde wird fr Rollen gespeichert
'     ab nz=360 wird nur jede zweite Marke bearbeitet
        IF nzsteuer = -1 THEN GOTO 9090
      IF colstd = 15 THEN colstd = 7:  ELSE colstd = 15
      nst = nst + 1
      xstunde(nst) = nzahl + 49
      locstunde(nst) = INT(nzahl + 45) / 8
      wertstunde(nst) = VAL(stunde$)
      LINE (xstunde(nst), 400 - 4)-(xstunde(nst), 1), 7
      LOCATE 51, locstunde(nst)
      COLOR colstd: PRINT USING "##"; wertstunde(nst)

9090    IF nz >= 360 THEN nzsteuer = nzsteuer * -1

     END SUB

      SUB syncro
      CLS
      LOCATE 10, 20: PRINT "Synchronisation der Schnittstelle"

'     Eingangssynchronisation der Schnittstelle
'     COM- Port ffnen: 2400 Baud, kein Parittsbit, 8 Datenbits, 1 Stopbit

      LOCATE 10, 10:              PRINT "             Empfangstest und Synchronisation der Eingangsdaten"
      LOCATE 13, 10: COLOR 0, 12: PRINT "kein Empfangssignal vorhanden, wenn nichts kommt, muss Prog. abgebrochen werden!": COLOR 15, 0

1121  errdiff = 0
      IF com$ = "1" THEN OPEN "COM1:2400,N,8,1,RS,CS,DS,CD" FOR INPUT AS #1
      IF com$ = "2" THEN OPEN "COM2:2400,N,8,1,RS,CS,DS,CD" FOR INPUT AS #1
      IF com$ = "3" THEN OPEN "COM3:2400,N,8,1,RS,CS,DS,CD" FOR INPUT AS #1
'     einlesen
1122   n = n + 1
      LOCATE 11, 20: PRINT n; ". Wertesatz "
      FOR i = 1 TO 14

'      Ein Datenbyte vom Telemetrie- Modul einlesen
     
       ON ERROR GOTO fehlers: IN$ = INPUT$(1, #1): ON ERROR GOTO 0

'      Daten als ASCII umspeichern
       w(i) = ASC(IN$)
      NEXT i
'      die 8 Analogkanle werden bearbeitet
'      nach dem 2. Wertesatz wird mit dem letzten verglichen
'      falls eine Abw. eines Kanales >10 vorliegt, wird errdiff=1
'      gesetzt
       LOCATE 13, 20
       FOR i = 1 TO 8
         PRINT w(i);
         IF n >= 2 THEN
           IF ABS(w(i) - w2sync(i)) > 10 THEN errdiff = 1
         END IF
         w2sync(i) = w(i)
       NEXT i
       IF n = 1 THEN GOTO 1122
'      nach 30 vergeblichen Versuchen wird abgebrochen
       IF n = 30 THEN
         LOCATE 11, 20: COLOR 0, 12: PRINT "         Schlechter Empfang, Abbruch bel. Taste"
         CALL alarm
         END
       END IF
       IF errdiff = 1 THEN CLOSE #1: GOTO 1121
      n = 0
    
      END SUB

      SUB ton
      FOR dum = 1 TO 10
        SOUND 100 + dum * 50 * RND, .5
      NEXT dum
      END SUB

      SUB tverschieb
'     alle Temperaturkanle verschieben im Speicher
      FOR m = 1 TO nk
        IF einheit$(m) = "t" THEN
          FOR mm = 1 TO nzahl
            yw(m, mm) = yw(m, mm) + (2 * 40) * tueber
          NEXT mm
          y0(m) = y0(m) + (2 * 40) * tueber
        END IF
      NEXT m
     
      CALL neu
     
      END SUB

      SUB werte
'     Bildschirmausgabe numerischer Werte
      FOR n = 0 TO 7
        LOCATE 55, n * 7 + 1
        COLOR col(n + 1)
        PRINT USING "####.#"; wm(n + 1)
      NEXT n

'     Zuordnung von Windrichtung Grad in Himmelsrichtung
       IF dd$ = "j" THEN
         dgrad = 22.5: grad = dgrad / 2
         FOR n = 2 TO 16
           IF wm(ikw) >= grad AND wm(ikw) < (grad + dgrad) THEN wiri$ = wr$(n)
           grad = grad + dgrad
         NEXT n
         IF wm(ikw) >= 348.75 OR wm(ikw) < 11.25 THEN wiri$ = wr$(1)'Nordsprung
         LOCATE 57, (ikw - 1) * 7 + 1: COLOR col(ikw): PRINT wiri$
       END IF


 '       Entfernung der summierten Windrose
         CALL roseweg
   


      t$ = TIME$
      LOCATE 53, 57: COLOR 15: PRINT t$
      COLOR 13
      LOCATE 53, 67: PRINT USING "####"; nfehler
               
      pfehler = nfehler / ninput1 * 100
'       gehen Fehler ueber mehr als ein Messintervall, wird ueber 100%
'       berechnet. Um dies zu vermeiden, wird dann = 100 gesetzt
      IF pfehler > 100 THEN pfehler = 100
      LOCATE 55, 67: PRINT USING "###.##"; pfehler
      COLOR 15
      LOCATE 55, 59: PRINT nzk
      LOCATE 57, 61: PRINT USING "#.##"; (nz / 120)
'     Windzhler
      IF ff$ = "j" THEN
        LOCATE 59, 68: COLOR colwind: PRINT USING "###.#"; wind;
      ELSE
        LOCATE 59, 68: PRINT "     ";
      END IF
'     reduzierter Druck wird nur als Wert ausgegeben und hier berechnet
'     CE= virtuelle Temperatur in K, Feuchte wird pauschal angenommen
'     Temperaturzunahme 0.6 Grad auf 100m, halbe Schicht, also 0.003 (Liliequist)
      CE = wm(ikr) + (.003 * h) + 273
      dr = (wm(ikd)) * 1 / (EXP(-9.81 * h / (287 * CE)))
      LOCATE 57, (ikd - 1) * 7 + 1: COLOR col(ikd): PRINT USING "####.#"; dr;
'     Drucktrend
      IF dtrend <> 0! THEN LOCATE 59, (ikd - 1) * 7 + 1: PRINT USING "####.#"; dtrend;
'      Ausgabe von Dampfdruck und Taupunkt
      IF pdampf > 17 THEN COLOR 14:  ELSE COLOR ikf
      LOCATE 57, (ikf - 1) * 7 + 1:  PRINT USING "####.#"; pdampf;
      LOCATE 59, (ikf - 1) * 7 + 1: COLOR ikf: PRINT USING "####.#"; tau;
'     Dateiausgabe Werte, zur Sicherheit wird Datei nach jeder Ausgabe
'       geschlossen und dann wieder geffnet, ab Zaehler nzk > wird angehaengt
'         nur wenn gewnscht
         IF d1$ <> "n" THEN
       IF nzk = 1 THEN OPEN d1$ FOR OUTPUT AS #3
       IF nzk > 1 THEN OPEN d1$ FOR APPEND AS #3
       PRINT #3, DATE$; "  "; t$;
       FOR n = 1 TO nk
         PRINT #3, USING "#####.#"; wm(n);
       NEXT n
'      Windgeschwindigkeit
       IF ff$ <> "j" THEN wind = -99.9
       PRINT #3, USING "####.#"; wind
'     Datei wird sicherheitshalber geschlossen, dann ist sie nach einem
'      Absturz wegen Stromausfall noch da
       CLOSE #3
         END IF

'     Zaehler fuer Fehler > 50%
      IF nzk > 5 AND pfehler > 50 THEN
        nf50 = nf50 + 1
      END IF
      LOCATE 57, 70: COLOR 13: PRINT nf50
      END SUB

      SUB windrichtungen
      wr$(1) = " N ": wr$(2) = "NNE": wr$(3) = " NE": wr$(4) = "ENE"
      wr$(5) = " E ": wr$(6) = "ESE": wr$(7) = " SE": wr$(8) = "SSE"
      wr$(9) = " S ": wr$(10) = "SSW": wr$(11) = " SW": wr$(12) = "WSW"
      wr$(13) = " W ": wr$(14) = "WNW": wr$(15) = " NW": wr$(16) = "NNW"
      END SUB

